/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CListView.cpp,v 1.1 1999/09/12 04:29:45 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "CListView.h"
#include "UModuleInstance.h"

_USING_PGP

// Class CListView member functions

PGPBoolean 
CListView::GetItemRect(PGPInt32 i, RECT *pRect, PGPInt32 code) const
{
	pRect->left = code;

	return static_cast<PGPBoolean>(SendMessage(LVM_GETITEMRECT, i, 
		reinterpret_cast<LPARAM>(pRect)));
}

PGPBoolean 
CListView::SetItemState(PGPInt32 i, PGPUInt32 state, PGPUInt32 mask)
{
	LVITEM	lvItem;

	lvItem.state = state;
	lvItem.stateMask = mask;

	return static_cast<PGPBoolean>(SendMessage(LVM_SETITEMSTATE, i, 
		reinterpret_cast<LPARAM>(&lvItem)));
}

void 
CListView::Create(
	HWND		parent, 
	PGPUInt32	id, 
	PGPUInt32	style, 
	PGPUInt32	exStyle, 
	PGPInt32	xOffset, 
	PGPInt32	yOffset, 
	PGPInt32	width, 
	PGPInt32	height)
{
	pgpAssert(!WeSubclassed());
	pgpAssert(CWindow::IsWindow(parent));

	HWND	hWnd	= ::CreateWindowEx(exStyle, WC_LISTVIEW, NULL, 
		WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | style, xOffset, 
		yOffset, width, height, parent, reinterpret_cast<HMENU>(id), 
		UModuleInstance::Get(), NULL);

	if (IsNull(hWnd))
		THROW_ERRORS(kPGPError_Win32WindowOpFailed, GetLastError());

	Subclass(hWnd);
}
